set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '201',
      '42241344',
      NULL,
      NULL,
      '4333324',
      33.585027,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      38.839587,
      NULL,
      0,
      NULL,
      0.574323,
      1.618166,
      0.946835,
      1.698327,
      1.982951,
      1.971044,
      1,
      2.207808,
      1.559686,
      NULL,
      NULL,
      0.054257,
      1.619086,
      NULL,
      0,
      0.584046,
      1,
      0,
      1,
      NULL,
      0,
      0.570563,
      NULL,
      0,
      0.136933,
      0,
      2,
      1,
      NULL,
      NULL,
      1.116396,
      NULL,
      NULL,
      1.346986,
      0,
      1,
      0.645186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.761244,
      0.152389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631425,
      1,
      1.035183,
      1,
      1,
      0,
      0.622862,
      1,
      1,
      NULL,
      0,
      1.290303,
      1.492777,
      1.988556,
      0,
      1,
      0.802000,
      0,
      1,
      NULL,
      1,
      0.950392,
      0.071724,
      NULL,
      0,
      0,
      0.002132,
      0.519031,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063639,
      1.358298,
      1,
      1,
      1.089208,
      0.193987,
      NULL,
      0,
      6.334158,
      1,
      1.893640,
      3,
      4.536245,
      0.151002,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290725,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.950537,
      1.243849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.939987,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.273960,
      1.812260,
      1.882626,
      0.784147,
      0.158445,
      0,
      1.072536,
      NULL,
      NULL,
      NULL,
      1.191238,
      1.330790,
      1.610748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.079929,
      0,
      0.045081,
      NULL,
      1,
      1,
      0,
      2.199494,
      0.384949,
      0.239142,
      1.673097,
      1.089666,
      0,
      0.008949,
      1.990406,
      1.520599,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '20201',
      '',
      '',
      0.919751,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      2,
      3.355275,
      3.456921,
      2,
      3.958061,
      0,
      1,
      2.853033);
commit;
end;
/


