set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      55,
      NULL,
      '3402140',
      118.471748,
      NULL,
      2.963519,
      2,
      NULL,
      NULL,
      ' 8-13-1989',
      21,
      NULL,
      0.976965,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.755798,
      NULL,
      0,
      3,
      1,
      1,
      0,
      1,
      NULL,
      5.105758,
      0,
      1,
      NULL,
      1,
      3,
      0.909368,
      NULL,
      0.676141,
      NULL,
      1,
      0.943590,
      0,
      5,
      1.383557,
      NULL,
      NULL,
      0.056238,
      NULL,
      NULL,
      1,
      0.467072,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.130201,
      0,
      1.843879,
      NULL,
      1,
      0,
      0.474880,
      1.034243,
      1.679314,
      0.748050,
      1,
      NULL,
      1,
      1,
      NULL,
      1.645587,
      0.449748,
      NULL,
      1.370014,
      1,
      NULL,
      NULL,
      1.460972,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.077348,
      NULL,
      0.793914,
      NULL,
      1.318872,
      0,
      2,
      NULL,
      5.024405,
      NULL,
      0,
      3,
      3.608534,
      1,
      1,
      1,
      1.677565,
      NULL,
      NULL,
      9,
      1.154118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.715630,
      1.128088,
      1,
      1,
      NULL,
      NULL,
      1.402498,
      1.257933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.662623,
      3,
      1,
      0.345352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.261303,
      0.543836,
      0.976704,
      NULL,
      NULL,
      NULL,
      1.231500,
      1,
      4.710151,
      0.959777,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.665298,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.334568,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      2.997309,
      1,
      0.534724,
      NULL,
      0.694191,
      1,
      1,
      NULL,
      1.344455,
      0,
      0.024384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.757852,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      NULL,
      2.068167,
      3,
      1.399100,
      NULL,
      3,
      1,
      2.543293,
      1,
      0);
commit;
end;
/


