set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      '02',
      10,
      0,
      '0343413',
      23.657113,
      5,
      1,
      0,
      NULL,
      5.516682,
      ' 0-10-1981',
      56,
      44,
      0.033158,
      NULL,
      1.494820,
      1.282460,
      2.100034,
      1.465794,
      0,
      1,
      0.782669,
      1.362640,
      1,
      1.483736,
      0.496639,
      1.257641,
      1,
      0.308856,
      1.516490,
      1,
      NULL,
      0,
      1.705897,
      1.534171,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562613,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309007,
      0.841549,
      0.448918,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071114,
      0.520847,
      1.602485,
      0.548159,
      1,
      3,
      NULL,
      1.376193,
      1.962439,
      0.798783,
      1.830045,
      NULL,
      1.698499,
      0,
      0.879923,
      1,
      1.062260,
      1.082138,
      0,
      NULL,
      0.633909,
      0.059577,
      0,
      0.074492,
      0,
      0,
      1.768098,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.183002,
      0,
      0.199257,
      1,
      1.011679,
      1.749165,
      1.526222,
      NULL,
      0,
      0,
      0.122017,
      0,
      NULL,
      0,
      1.221447,
      1,
      NULL,
      NULL,
      6.325433,
      0.755174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458317,
      1,
      0,
      1,
      NULL,
      0.209246,
      NULL,
      1.369327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.927502,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298469,
      0.834019,
      1.481839,
      1,
      1,
      1,
      0.364154,
      NULL,
      NULL,
      NULL,
      1,
      0.948253,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102886,
      1.899622,
      0,
      1,
      1.950325,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808612,
      0,
      1,
      0.371788,
      NULL,
      0.871310,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '2234',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


