set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      '30300021',
      NULL,
      33,
      '1411200',
      33,
      1,
      3,
      0,
      NULL,
      4,
      '11-29-1989',
      93,
      76,
      1,
      NULL,
      15,
      1,
      1,
      0.856552,
      1.879501,
      NULL,
      1.594098,
      NULL,
      1,
      1,
      0,
      NULL,
      0.256327,
      0,
      1.508593,
      1.366746,
      NULL,
      NULL,
      1,
      0,
      1,
      1.243067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836341,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.268093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.803252,
      NULL,
      1,
      0,
      0.526370,
      1,
      1,
      0.755090,
      NULL,
      NULL,
      1,
      NULL,
      0.782179,
      0.961138,
      0,
      0.159567,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.576955,
      1.657061,
      1.131120,
      0.068720,
      NULL,
      0,
      0.739309,
      NULL,
      0,
      0.736816,
      0,
      1,
      1.584644,
      0.514455,
      1.699757,
      1.710403,
      NULL,
      1.603326,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0.038035,
      NULL,
      NULL,
      3.516404,
      1.264616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.703654,
      1,
      NULL,
      1,
      0.575578,
      1.632614,
      1.454594,
      0.210386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.986461,
      NULL,
      NULL,
      NULL,
      NULL,
      1.437933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.562243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.367346,
      0,
      1.445585,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.660585,
      1.030039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187308,
      0,
      0.540875,
      0.063906,
      1,
      0.559602,
      1.102392,
      1.801189,
      0.435514,
      0.767020,
      1,
      1.151071,
      NULL,
      NULL,
      1,
      1,
      0.871482,
      1,
      1.643495,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.955917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.305541,
      '4314',
      '',
      '',
      0.911128,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.767134,
      3,
      1,
      2,
      2.255717,
      0,
      0.844335,
      1.594573,
      1.324806);
commit;
end;
/


