set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      '31404234',
      60,
      NULL,
      '3201030',
      12.840314,
      0,
      NULL,
      2,
      '034410',
      5,
      ' 3- 1-1976',
      130.145906,
      NULL,
      1.963410,
      NULL,
      NULL,
      NULL,
      2,
      1.924829,
      NULL,
      0.146724,
      0,
      1,
      1.128669,
      0,
      1.254458,
      1.151288,
      1,
      NULL,
      NULL,
      0.871747,
      NULL,
      1,
      NULL,
      1.407219,
      0.065867,
      1.081794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.806854,
      NULL,
      0.138835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.647401,
      0.833394,
      0,
      1,
      1.736911,
      1,
      1,
      1,
      0.775837,
      1,
      1,
      NULL,
      1.227333,
      NULL,
      0.810170,
      1,
      NULL,
      NULL,
      NULL,
      0.698640,
      0.452580,
      1.869793,
      NULL,
      1,
      1,
      0,
      0.272123,
      1,
      1,
      1.034808,
      0.123678,
      0.141402,
      1,
      NULL,
      0,
      1,
      0.539359,
      0.243009,
      1.960934,
      1.853680,
      0,
      1.701942,
      1.104422,
      0.410292,
      1,
      0.945112,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679932,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.807500,
      1,
      1,
      1.423955,
      NULL,
      NULL,
      0.547402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6.709317,
      NULL,
      3,
      5,
      0.470186,
      0.725216,
      0,
      1.917895,
      2,
      NULL,
      1,
      0,
      1.530095,
      NULL,
      NULL,
      1,
      1,
      4.197060,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345689,
      0.024996,
      1,
      0.419631,
      1.589016,
      NULL,
      1,
      1,
      1.859087,
      1.684740,
      NULL,
      1.197918,
      0,
      NULL,
      NULL,
      0,
      0,
      0.867227,
      1.985877,
      0.488056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '0414',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.822448,
      '',
      NULL,
      NULL,
      0.026483,
      3,
      NULL,
      0.395251,
      3.314149,
      1,
      3.643000,
      1,
      2.254493);
commit;
end;
/


