set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9237179';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '023',
      '33',
      12.644663,
      5.286791,
      NULL,
      76.488737,
      0,
      1,
      1,
      '323033',
      4,
      ' 7-23-1979',
      NULL,
      9,
      1,
      NULL,
      0.781293,
      0.442209,
      3,
      NULL,
      0.157369,
      1,
      0.512923,
      1.238332,
      0,
      0,
      NULL,
      1.436711,
      NULL,
      0.764795,
      5,
      1,
      1,
      1.814536,
      1.291822,
      0.389868,
      1.798662,
      1,
      2.836660,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      3.726156,
      1,
      0,
      0,
      0.821649,
      2,
      0,
      0.526513,
      2,
      1.121019,
      0,
      1,
      3,
      1.347087,
      2.807447,
      1,
      0,
      NULL,
      1,
      1,
      1.294345,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509006,
      0.714226,
      1.725575,
      1,
      1,
      NULL,
      1.587506,
      NULL,
      0.109102,
      2,
      6.602829,
      1.302281,
      0,
      2,
      1.001119,
      0,
      1,
      NULL,
      0,
      NULL,
      0.997439,
      0.025098,
      NULL,
      NULL,
      0,
      1.163963,
      5.947137,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1.344520,
      1,
      NULL,
      NULL,
      0.112742,
      1.229288,
      NULL,
      1,
      7.160092,
      NULL,
      7.863941,
      6.948206,
      2.722332,
      NULL,
      NULL,
      1.970308,
      NULL,
      NULL,
      6.536729,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327564,
      0.079683,
      2,
      0,
      1,
      0.346314,
      0.361576,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525815,
      NULL,
      NULL,
      NULL,
      NULL,
      3.104791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.252174,
      1,
      0.305014,
      1.580205,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.251880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.353269,
      0,
      0,
      0.904672,
      NULL,
      0.124719,
      1,
      1,
      NULL,
      0.995416,
      1.461462,
      0,
      1.472041,
      NULL,
      0,
      0,
      0,
      0,
      0.919373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '02132',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.683330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


