set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9237179';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01014032',
      40,
      62,
      '1333201',
      66.429350,
      4,
      1.453306,
      3,
      NULL,
      2.070732,
      ' 8-26-1980',
      44.911296,
      35.277723,
      NULL,
      NULL,
      1,
      0.143892,
      2,
      NULL,
      0.361192,
      NULL,
      0.850600,
      1,
      0.026986,
      0.153981,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0.882340,
      1.255559,
      1.001698,
      1.192069,
      1.631260,
      1.674016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531666,
      1.679506,
      0,
      1.382052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188333,
      1,
      NULL,
      1.452002,
      1,
      NULL,
      NULL,
      1.342777,
      0,
      2,
      0,
      NULL,
      0,
      3.622473,
      1.107171,
      NULL,
      NULL,
      1.081799,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1.112232,
      1,
      0,
      3.110178,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496108,
      1,
      0,
      0.597030,
      1.073436,
      0.730835,
      0,
      0,
      2.042513,
      5.440441,
      NULL,
      NULL,
      NULL,
      0.099892,
      0.954276,
      1.073531,
      1,
      NULL,
      NULL,
      1.904838,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.009620,
      NULL,
      0,
      0.009496,
      0,
      0,
      0.660031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779420,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829376,
      1,
      1.188825,
      0,
      NULL,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.295104,
      2,
      1,
      0.764259,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.002322,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.720714,
      1,
      1.211221,
      NULL,
      1.538437,
      NULL,
      0.314929,
      NULL,
      3.530538,
      0,
      1.556297,
      1.477835,
      0.951097,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '31400',
      '',
      '',
      0.628072,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      1.880853,
      3,
      3.924664,
      0.156034,
      NULL,
      1.763887,
      0,
      3.929700);
commit;
end;
/


