set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9237179';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0422',
      NULL,
      NULL,
      27.924112,
      '4234044',
      180.929906,
      NULL,
      2,
      1,
      '421222',
      NULL,
      ' 5-27-1982',
      53.007044,
      NULL,
      0,
      NULL,
      0,
      1,
      0.551770,
      0.361931,
      1,
      1,
      0,
      3,
      0,
      0.313307,
      0.949042,
      0,
      NULL,
      NULL,
      0.818811,
      0,
      0.355937,
      1,
      NULL,
      0.781895,
      NULL,
      1,
      1.403941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.087389,
      0.698443,
      2.759048,
      NULL,
      2.980581,
      0,
      0.957530,
      NULL,
      1,
      0.275108,
      0.048685,
      2,
      NULL,
      3,
      1,
      0.524726,
      0.427791,
      4,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.771480,
      1.654067,
      1,
      NULL,
      NULL,
      2.399404,
      0,
      0,
      0,
      NULL,
      0,
      0.837255,
      2.394532,
      0,
      0.557704,
      0,
      NULL,
      1,
      NULL,
      1,
      1.830927,
      1.086192,
      1.972705,
      NULL,
      1.313049,
      NULL,
      0.507416,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470214,
      NULL,
      NULL,
      1.386957,
      0,
      1.509443,
      1,
      1,
      1,
      0,
      2.209942,
      NULL,
      3.070327,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.534084,
      1,
      0,
      0,
      NULL,
      NULL,
      0.822935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647980,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.151428,
      NULL,
      1,
      2.490466,
      0,
      0,
      0.286175,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.164790,
      2,
      0.861572,
      0.646358,
      0,
      0,
      1,
      3.565619,
      NULL,
      0.752502,
      1,
      0.613915,
      0,
      1.725347,
      1.692742,
      1.943971,
      1,
      0.801689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.167977,
      '00431',
      '',
      '',
      1.077196,
      NULL,
      NULL,
      '',
      0.295145,
      '',
      '',
      '',
      1,
      3.866262,
      NULL,
      1,
      2,
      3.165756,
      3.749598,
      3.147398,
      2.594395);
commit;
end;
/


