set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8500287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      54,
      '1440242',
      9,
      NULL,
      3,
      2,
      '033443',
      3,
      '11-21-1996',
      65.192260,
      6.111074,
      1,
      NULL,
      0.690516,
      2,
      NULL,
      0.515939,
      2,
      1,
      NULL,
      2.415822,
      1.359443,
      1.032438,
      1.110358,
      1.662435,
      7.586958,
      0.989477,
      1.728297,
      4,
      NULL,
      1,
      3.814384,
      0.268504,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.548875,
      0.812083,
      NULL,
      NULL,
      1.861411,
      NULL,
      NULL,
      2.007887,
      5,
      NULL,
      NULL,
      0.039381,
      0,
      1,
      2,
      1.488408,
      NULL,
      3,
      NULL,
      0,
      1.018857,
      0.967720,
      0.621929,
      1.325105,
      3.805330,
      1.977083,
      1.100763,
      1.463484,
      0.231142,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609218,
      NULL,
      3,
      1,
      2,
      0,
      2,
      0.227665,
      1.446017,
      NULL,
      0.072295,
      0.612655,
      1.013339,
      2,
      NULL,
      1,
      1,
      0.753986,
      1.391109,
      NULL,
      NULL,
      NULL,
      2.367783,
      NULL,
      NULL,
      1,
      2.705383,
      1.528602,
      3,
      1.765593,
      0.400487,
      1,
      NULL,
      5.112500,
      0.611532,
      1.445548,
      0,
      4,
      1.414923,
      1.379803,
      NULL,
      1.267432,
      5.067817,
      NULL,
      4.473752,
      6.514292,
      1.204367,
      3.180368,
      0,
      0,
      1,
      4,
      0.013127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570674,
      NULL,
      NULL,
      1,
      NULL,
      1.363478,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.725984,
      1.274127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.462776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.387209,
      4.599199,
      5,
      3,
      NULL,
      0.656588,
      1.234678,
      NULL,
      NULL,
      0,
      5,
      1.687639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.194059,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.299329,
      3.540400,
      NULL,
      1.921099,
      NULL,
      1.223512,
      1,
      1,
      0.420107,
      1,
      0.520167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.896331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642193,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077263,
      NULL,
      1.916535,
      NULL,
      0.332585,
      1.260383,
      0,
      2,
      1.347760,
      '0422',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.239963,
      6,
      0.910189,
      3,
      3,
      1,
      1.604801,
      2.339618,
      2.034099);
commit;
end;
/


