set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9850425';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '030',
      '10142333',
      50,
      18,
      '2101414',
      NULL,
      3,
      0,
      NULL,
      '042031',
      1,
      ' 2- 7-1999',
      175.243322,
      137,
      0.922584,
      NULL,
      0,
      3,
      0,
      1,
      1,
      1.589552,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777741,
      1,
      1.761262,
      3.145983,
      1.270858,
      1.576686,
      NULL,
      0,
      0,
      5.842252,
      NULL,
      2,
      0,
      1.910423,
      1.714506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452967,
      1,
      0.053604,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.916997,
      0.338879,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.576762,
      1,
      0.500229,
      NULL,
      3.718574,
      1.067730,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      0.990798,
      0,
      0.359934,
      1.501384,
      1,
      NULL,
      0,
      3.961198,
      1.284230,
      1,
      0,
      NULL,
      0,
      NULL,
      2.223928,
      0,
      0.484071,
      3,
      NULL,
      0,
      5.667429,
      1,
      5.536047,
      1,
      6.823333,
      0.655062,
      1.929356,
      5,
      NULL,
      1.895740,
      1,
      1,
      NULL,
      0,
      1.498413,
      NULL,
      NULL,
      NULL,
      0.980781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.114211,
      0.018239,
      1,
      0,
      0,
      1,
      1.150928,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847101,
      NULL,
      NULL,
      NULL,
      NULL,
      6.836434,
      NULL,
      3,
      0,
      1,
      6.544413,
      0,
      1.981240,
      0.187418,
      NULL,
      NULL,
      NULL,
      1.759023,
      0,
      6.153368,
      4,
      0,
      0,
      0.414578,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.513089,
      NULL,
      1,
      3.178140,
      NULL,
      3.845760,
      1.690216,
      1,
      2,
      1,
      0,
      NULL,
      0.612916,
      NULL,
      0,
      NULL,
      1,
      0.534676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.765513,
      '03442',
      '',
      '',
      1.307178,
      '',
      NULL,
      '',
      1.468347,
      '',
      '',
      '',
      3,
      0,
      1,
      4.981780,
      0,
      NULL,
      1,
      1.328743,
      1.741541);
commit;
end;
/


