set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9850425';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '02422104',
      66.436550,
      NULL,
      '4413033',
      5,
      2,
      NULL,
      NULL,
      '323323',
      NULL,
      NULL,
      6,
      97,
      NULL,
      NULL,
      3.173360,
      0,
      0.718264,
      0.753858,
      0.857021,
      0,
      1,
      3.271014,
      1.609060,
      0,
      2.566247,
      1,
      0,
      1,
      2.012898,
      1.451149,
      2,
      0,
      0.127089,
      1.370960,
      1.493759,
      0,
      5,
      0,
      4,
      NULL,
      0,
      0.422399,
      NULL,
      NULL,
      0.912147,
      NULL,
      NULL,
      0,
      1,
      1.405914,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.611524,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920466,
      0.837833,
      0,
      1,
      4.025856,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860815,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1.836786,
      7.676193,
      0,
      3.136445,
      NULL,
      NULL,
      7,
      0.764551,
      1,
      1.632623,
      2.887532,
      5.790399,
      1.163561,
      4.697187,
      5.450633,
      1,
      5.835476,
      0.294941,
      3.135351,
      1,
      8.865581,
      0.258396,
      0.679864,
      6,
      6.972831,
      1,
      1.550508,
      1.784224,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.965336,
      0,
      0,
      NULL,
      0.639850,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      0,
      0,
      NULL,
      NULL,
      5.727726,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      8,
      3.460053,
      1.479613,
      0,
      1.095253,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939417,
      NULL,
      3.091189,
      0.965099,
      1,
      0,
      0.492047,
      2,
      0,
      3,
      3.107788,
      NULL,
      0,
      1,
      1,
      1.667723,
      1,
      NULL,
      NULL,
      0.281520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '31321',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.899947,
      '',
      NULL,
      '',
      0,
      0.154754,
      3.153413,
      NULL,
      NULL,
      2,
      2,
      3.550265,
      2);
commit;
end;
/


