set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      9,
      3,
      0.612948,
      NULL,
      '214200',
      0,
      ' 4- 7-1988',
      49,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921851,
      0,
      0,
      1,
      3,
      1.009690,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      1.804697,
      0,
      0,
      NULL,
      0,
      NULL,
      0.866321,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.793858,
      1.610143,
      3.825756,
      3,
      0.500229,
      NULL,
      1.905374,
      1.043994,
      0,
      0,
      3,
      0.591201,
      0,
      NULL,
      NULL,
      1.218483,
      2.822586,
      1.470120,
      0,
      1,
      0.734644,
      NULL,
      3,
      0,
      NULL,
      1,
      1.541505,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.164250,
      0,
      0,
      NULL,
      NULL,
      0.671815,
      1,
      0,
      0,
      1.654755,
      1,
      0.591481,
      0,
      1,
      1,
      0,
      0.088088,
      NULL,
      0.963428,
      NULL,
      NULL,
      0.713651,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5.090409,
      0,
      NULL,
      0,
      1.644620,
      3.412983,
      5.238816,
      1,
      NULL,
      4.631573,
      1.496816,
      4,
      3,
      6,
      6.821499,
      9.043220,
      NULL,
      2.991712,
      NULL,
      NULL,
      0.748521,
      0.953110,
      1,
      4.914923,
      0.171990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.622404,
      1.596418,
      1.883099,
      1.922681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.427385,
      NULL,
      0.556846,
      NULL,
      1.026697,
      2.888927,
      1.049394,
      NULL,
      NULL,
      NULL,
      3.046637,
      1.390202,
      0.612695,
      4,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.486643,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.156017,
      0.159173,
      NULL,
      3.674165,
      1,
      1.142552,
      0,
      0,
      0,
      0,
      0,
      0.916638,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '32402',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


