set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '3110143',
      25.411655,
      3,
      3.624134,
      3,
      '013213',
      3.460576,
      NULL,
      42,
      NULL,
      0,
      NULL,
      NULL,
      0.090283,
      3,
      0.556311,
      0.937664,
      3.829375,
      NULL,
      NULL,
      3.947944,
      NULL,
      1.112715,
      0,
      0.591933,
      1.735543,
      0,
      1,
      6.869150,
      0.451784,
      9.069257,
      1,
      1,
      1.709672,
      1.027222,
      1,
      3.414713,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.266852,
      6,
      3.990577,
      1.122858,
      NULL,
      1,
      1.782736,
      1,
      1.788810,
      1,
      1,
      NULL,
      2,
      2,
      3,
      1.123075,
      NULL,
      NULL,
      0.608612,
      NULL,
      0,
      7,
      1,
      2,
      1.666260,
      0,
      NULL,
      NULL,
      1.479893,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.952273,
      1,
      0.007541,
      0.006713,
      1.029444,
      1,
      1,
      1.812400,
      1.449116,
      1.348553,
      1.827570,
      1.104829,
      1,
      0.126475,
      1,
      1.035169,
      NULL,
      0.436787,
      0.022001,
      0,
      NULL,
      0,
      0,
      3,
      0.171823,
      NULL,
      2.587802,
      5,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.221364,
      6.691586,
      7.511006,
      7.124652,
      NULL,
      1,
      NULL,
      3,
      10.735842,
      4,
      3.790385,
      NULL,
      NULL,
      4.995420,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992206,
      NULL,
      0,
      1,
      1,
      0.056169,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2.064816,
      0,
      6,
      3,
      NULL,
      1.852255,
      1,
      3,
      5.191632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151000,
      NULL,
      0.495700,
      NULL,
      3.572893,
      1,
      5.509747,
      1.897662,
      NULL,
      NULL,
      0.564268,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.393658,
      NULL,
      2.490312,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.751314,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.976212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      '',
      1.119816,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


