set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      '34',
      NULL,
      5,
      '4212303',
      30,
      2,
      1.267826,
      3,
      '202231',
      4,
      ' 5-29-1998',
      16.472888,
      15.282550,
      1.928709,
      NULL,
      0,
      1.617473,
      2.987366,
      0,
      0,
      1.027707,
      0,
      0,
      1.209330,
      NULL,
      3.202515,
      NULL,
      1.017201,
      0.592509,
      1.442043,
      0.622383,
      8,
      1,
      6,
      0,
      1,
      1.611667,
      3,
      0,
      NULL,
      0,
      NULL,
      0.545960,
      NULL,
      NULL,
      0.157187,
      NULL,
      NULL,
      3.761589,
      1.505819,
      0,
      NULL,
      1,
      NULL,
      1.685204,
      0,
      0.624187,
      NULL,
      0.901198,
      0.795770,
      1.854587,
      NULL,
      NULL,
      1.821815,
      NULL,
      0,
      0,
      4.056228,
      3,
      2.575420,
      NULL,
      1,
      1,
      0.747286,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      1,
      3.832975,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1.953187,
      NULL,
      NULL,
      1.313322,
      0.157350,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0.154701,
      0,
      1,
      1,
      2.813797,
      0.504669,
      NULL,
      NULL,
      2,
      0,
      2,
      1,
      1.696863,
      7.496785,
      5,
      4,
      2.549558,
      1.669432,
      9,
      0.667842,
      4.957885,
      NULL,
      6,
      1,
      7.290878,
      1.506958,
      1.120593,
      NULL,
      1,
      3.528213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424003,
      NULL,
      0,
      1.686577,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281574,
      3.349855,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      2.740681,
      3.232815,
      0,
      1,
      0,
      NULL,
      NULL,
      0.261959,
      0,
      1.986885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268745,
      2,
      3.231676,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.289522,
      NULL,
      1.184235,
      0.946583,
      NULL,
      0,
      NULL,
      1,
      1,
      0.363606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.849073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286187,
      '00242',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


