set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '242',
      '12',
      8.967442,
      18.310676,
      '3010430',
      NULL,
      NULL,
      NULL,
      1,
      '312234',
      0,
      '10- 6-2001',
      48,
      NULL,
      0.146745,
      NULL,
      0.068467,
      NULL,
      NULL,
      0,
      1.323388,
      NULL,
      0.353553,
      0,
      1,
      0.635465,
      7,
      0.135383,
      1.760082,
      1.973139,
      0,
      1.154801,
      6,
      1,
      4.808967,
      0,
      0,
      1,
      6,
      0,
      3.288954,
      0,
      0,
      1.508565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      5,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.851469,
      0.364153,
      NULL,
      1.036439,
      1,
      NULL,
      0,
      1,
      0,
      1.910555,
      NULL,
      1,
      3,
      NULL,
      5,
      NULL,
      NULL,
      1.612149,
      0.326957,
      NULL,
      NULL,
      0.699281,
      NULL,
      NULL,
      1,
      0.597075,
      3.712402,
      1,
      2.859463,
      1,
      NULL,
      0,
      0,
      1,
      0.080440,
      1,
      0,
      NULL,
      0,
      0,
      0.720242,
      0.124869,
      0.858600,
      NULL,
      NULL,
      NULL,
      1.264765,
      NULL,
      1,
      1.743342,
      1.002153,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.280356,
      NULL,
      NULL,
      6,
      NULL,
      2,
      3,
      11.722121,
      5,
      0.121679,
      5,
      0.467930,
      1.043464,
      NULL,
      1,
      0.722712,
      1,
      1,
      1.399109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249757,
      1.361473,
      0,
      1,
      0,
      0,
      0.580094,
      1.681151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.141272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.131035,
      2.495105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.239417,
      NULL,
      0.774865,
      1,
      1.522359,
      0.968604,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1.634966,
      3.938227,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0.030500,
      0.822370,
      0.408330,
      0.224622,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.158576,
      '44012',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


