set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '420',
      NULL,
      NULL,
      22,
      NULL,
      76,
      5,
      2.908697,
      2,
      '422134',
      3,
      ' 5- 3-1982',
      41,
      33,
      0,
      NULL,
      1.528937,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1.440030,
      0.743379,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      8.238316,
      0,
      1,
      NULL,
      0,
      0,
      6.739854,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      1.785405,
      2,
      0,
      0,
      1.714119,
      NULL,
      0,
      3,
      2,
      2,
      1.357922,
      0.290554,
      0.137546,
      NULL,
      4,
      NULL,
      6,
      0,
      NULL,
      NULL,
      0.959174,
      NULL,
      NULL,
      0.637953,
      NULL,
      NULL,
      1.053343,
      0.900209,
      NULL,
      0,
      0.003738,
      0.604876,
      0.303910,
      0,
      1,
      1.560478,
      1.774787,
      NULL,
      0,
      0,
      NULL,
      1.779121,
      0.820501,
      1.411683,
      0,
      NULL,
      NULL,
      0.004261,
      0,
      NULL,
      1,
      0,
      0,
      0.516758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      6,
      5.703425,
      11.397216,
      NULL,
      1.602824,
      NULL,
      6.391251,
      10,
      NULL,
      NULL,
      10,
      NULL,
      0.907514,
      1.860015,
      NULL,
      NULL,
      1.947242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      1,
      0,
      0.067076,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.247126,
      NULL,
      NULL,
      1.991509,
      1.795369,
      4,
      2.216630,
      0,
      0,
      0.165482,
      11.101770,
      8.899964,
      NULL,
      1.738787,
      NULL,
      NULL,
      NULL,
      1.407552,
      1.777346,
      7,
      1.835278,
      5,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.722754,
      0,
      2.753674,
      NULL,
      0,
      2.817802,
      3.427832,
      1,
      2,
      1,
      1,
      1,
      NULL,
      1.039607,
      1.536336,
      1,
      0.711917,
      1.985604,
      1.256881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '01030',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.891159,
      NULL,
      '',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


