set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32',
      8,
      9,
      '3313403',
      28.058509,
      0,
      3.827752,
      1,
      '224423',
      NULL,
      ' 9-23-2003',
      24,
      14.220750,
      0,
      NULL,
      1,
      NULL,
      1,
      1.877276,
      NULL,
      1.769498,
      NULL,
      0.373547,
      0,
      0,
      0,
      1.811215,
      1.379448,
      1.124665,
      1,
      1,
      2.378220,
      0.789757,
      6,
      1.547708,
      0,
      1.740672,
      2,
      1,
      2,
      1,
      3.195943,
      0.725220,
      NULL,
      NULL,
      0.623154,
      NULL,
      NULL,
      1.325098,
      0.909737,
      0,
      2.674681,
      NULL,
      0,
      3.919678,
      0.610148,
      0.794914,
      3,
      2,
      0.040615,
      3.130667,
      1.693598,
      1,
      1.260955,
      NULL,
      0.440347,
      NULL,
      NULL,
      NULL,
      1,
      4.499317,
      1,
      NULL,
      NULL,
      1.749154,
      NULL,
      NULL,
      0.542346,
      NULL,
      NULL,
      1.074920,
      0.612337,
      3,
      1.238404,
      5,
      1,
      NULL,
      0.648518,
      0,
      1.765522,
      NULL,
      NULL,
      1.129050,
      1,
      0.132434,
      1,
      1,
      NULL,
      0.583540,
      NULL,
      0.307287,
      NULL,
      1,
      1.503025,
      1,
      1.865180,
      1,
      1.993394,
      NULL,
      NULL,
      NULL,
      NULL,
      1.308624,
      NULL,
      4.876212,
      0.725892,
      NULL,
      8.724897,
      3.761833,
      6,
      NULL,
      6,
      1,
      8,
      6,
      1.413052,
      0,
      NULL,
      2.356115,
      0,
      0.298468,
      5.699889,
      1.019572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      0.344108,
      0,
      0.431552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7.536328,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.688976,
      2,
      3,
      5.720556,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.093323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738677,
      3.645290,
      NULL,
      0,
      0.126331,
      1,
      2.030043,
      0.277153,
      1.687093,
      1.279317,
      NULL,
      NULL,
      0,
      0.018498,
      0.617768,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.066204,
      '32224',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.537371,
      '',
      NULL,
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


