set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04',
      41.180613,
      NULL,
      '1342002',
      91.050175,
      2,
      NULL,
      0,
      '021344',
      NULL,
      ' 3- 1-1989',
      20,
      14,
      0.827786,
      NULL,
      1,
      0.014956,
      3,
      1.540276,
      1.964191,
      NULL,
      1,
      0.639759,
      0,
      1,
      5.754184,
      1,
      NULL,
      1.618271,
      NULL,
      3,
      1.840799,
      0.784672,
      3,
      1.286750,
      1,
      1.802558,
      5.248696,
      0,
      2.627148,
      1.125001,
      1.317592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.248742,
      0,
      1.944439,
      2.436915,
      1,
      1,
      2,
      3.628927,
      0,
      2,
      2,
      1,
      3.525514,
      1,
      NULL,
      NULL,
      0,
      NULL,
      8.340042,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      4.828930,
      0.339111,
      1.712943,
      NULL,
      1,
      0,
      1,
      1.998767,
      1,
      NULL,
      1.765120,
      0,
      0,
      1.215923,
      1.942336,
      NULL,
      NULL,
      0,
      0,
      1,
      0.926866,
      0.108018,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.582514,
      2.429251,
      1.914048,
      0,
      0,
      NULL,
      0,
      0,
      9.277039,
      7.710186,
      NULL,
      6,
      NULL,
      2.041508,
      NULL,
      NULL,
      3.173632,
      1.178213,
      1.381200,
      5,
      1.947791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.504663,
      0,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.832468,
      NULL,
      7,
      0.992677,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.464318,
      NULL,
      NULL,
      NULL,
      0,
      1.763543,
      1.972171,
      NULL,
      0.325815,
      NULL,
      3,
      1.710151,
      NULL,
      NULL,
      0.870763,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.411144,
      1.405166,
      3,
      1.943276,
      1,
      0.263355,
      3,
      1,
      3,
      2.684046,
      0,
      0.476160,
      1.109421,
      1,
      0,
      1.071148,
      1.078088,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '43432',
      '',
      '',
      1.747959,
      '',
      '',
      '',
      0,
      '1334',
      '',
      '',
      3.424271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


