set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '142',
      '31',
      51.007927,
      35.698080,
      '4101233',
      124.776830,
      2,
      2,
      1,
      '412410',
      1.980337,
      '10-14-1985',
      30.538424,
      15.659811,
      0.345372,
      NULL,
      0.237152,
      1,
      0,
      0.335599,
      1.800830,
      1,
      0,
      0,
      NULL,
      0.941736,
      NULL,
      0.212195,
      1.319885,
      NULL,
      0,
      0,
      2.297523,
      0,
      3.319267,
      0,
      1.387022,
      NULL,
      3.864509,
      NULL,
      NULL,
      NULL,
      1,
      1.639237,
      NULL,
      NULL,
      1.636910,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.120789,
      1.486228,
      1,
      0.228752,
      1,
      0.920965,
      2,
      2.140492,
      0.583159,
      2.572868,
      NULL,
      NULL,
      0,
      3.541296,
      0.746287,
      0,
      1.653507,
      0.673282,
      0,
      5,
      1,
      1,
      1,
      1.054333,
      NULL,
      NULL,
      1.785923,
      NULL,
      NULL,
      0,
      0,
      4,
      0,
      0.900598,
      1,
      NULL,
      1.147244,
      1.596213,
      0,
      1.720401,
      1.154787,
      1,
      1,
      0,
      0,
      0.047824,
      0,
      0,
      NULL,
      NULL,
      1.927825,
      0.482336,
      0,
      1.781840,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.851350,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.524673,
      2.715546,
      6.303244,
      8,
      NULL,
      3,
      2.529849,
      4.912119,
      2.833387,
      0.393520,
      1,
      4.508876,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.079580,
      0.546209,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.600782,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043869,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.673823,
      4,
      0.959184,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.579068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776215,
      1,
      0,
      NULL,
      0,
      0,
      1.006674,
      0.989504,
      1.662932,
      2,
      0,
      1,
      0,
      1.670637,
      NULL,
      1,
      NULL,
      0.129004,
      0.657627,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.257435,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      2.590678,
      NULL,
      '',
      '',
      0,
      2.118517,
      NULL,
      1.031296,
      1.971372,
      0,
      1,
      NULL,
      0.165898);
commit;
end;
/


