set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      '43433314',
      34,
      48.555369,
      '1424331',
      15.882194,
      5,
      3.817958,
      1,
      NULL,
      3.139109,
      '11-20-1984',
      57,
      NULL,
      0.050192,
      NULL,
      NULL,
      0.956723,
      2.538433,
      1,
      NULL,
      NULL,
      0.953917,
      1,
      1,
      1.279714,
      0.245993,
      NULL,
      0,
      0,
      0,
      0,
      4.906922,
      0,
      5.591187,
      0.925370,
      NULL,
      1,
      0.733655,
      0,
      2.486804,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.729900,
      0.699916,
      7.017355,
      3,
      1.132313,
      NULL,
      3.333356,
      1,
      0,
      0.921101,
      0,
      1,
      1.571526,
      2.301675,
      2,
      1.630635,
      2.641311,
      0.252308,
      NULL,
      2.180109,
      1,
      9,
      3.492679,
      1,
      NULL,
      0,
      0.806983,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.255180,
      1,
      NULL,
      NULL,
      1.027507,
      0.284591,
      NULL,
      1.074459,
      0.599032,
      0.852304,
      1.883355,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.618338,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.613505,
      NULL,
      2,
      0,
      7,
      2.170946,
      3.285265,
      NULL,
      6,
      NULL,
      1.062257,
      8.687628,
      8,
      0,
      NULL,
      2.783684,
      0,
      1.131739,
      0.935901,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197856,
      0.416157,
      0,
      1,
      1.228775,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.717445,
      NULL,
      5,
      1,
      0,
      1.443770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.072429,
      1.369859,
      3.103495,
      2,
      1.634543,
      0,
      2.729066,
      0,
      NULL,
      NULL,
      0.471099,
      5.824940,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008804,
      1,
      NULL,
      NULL,
      0,
      0.224367,
      2.986354,
      3,
      0.320240,
      NULL,
      2.720012,
      0,
      1,
      1,
      1.921227,
      0,
      1,
      1.516322,
      NULL,
      0.507838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '21234',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '0324',
      '',
      '',
      5.874228,
      0,
      1.434781,
      2.864438,
      0,
      3,
      NULL,
      1,
      NULL);
commit;
end;
/


