set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '311',
      NULL,
      36,
      NULL,
      '3134131',
      NULL,
      6,
      NULL,
      1,
      '404020',
      5,
      NULL,
      43,
      118.747980,
      1.616417,
      NULL,
      1,
      1.627694,
      2.075987,
      1.460197,
      1,
      0,
      1.850123,
      0.042618,
      1.344367,
      1,
      NULL,
      0,
      0,
      0.268430,
      1.148102,
      1,
      NULL,
      NULL,
      6,
      1,
      1,
      1.022844,
      5,
      1,
      2.685124,
      1.318560,
      2.722063,
      0.121099,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.639947,
      1.831028,
      3.448595,
      0.662403,
      1,
      0.202086,
      3,
      1.970507,
      0.831297,
      0.055109,
      2,
      NULL,
      1,
      3.831362,
      1,
      NULL,
      NULL,
      1.447840,
      0,
      0,
      NULL,
      7.800519,
      4,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.733894,
      2,
      1,
      3,
      0,
      1.693615,
      0.142822,
      1.678708,
      1.010701,
      1.498625,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1.892565,
      1.411059,
      0,
      0,
      2.359730,
      0,
      2.395612,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      0,
      6,
      5.742080,
      2.161083,
      NULL,
      6.382759,
      NULL,
      2.575720,
      0,
      9,
      0.330196,
      10.736706,
      1.924590,
      3,
      NULL,
      1.770831,
      1.538672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884612,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.384582,
      1,
      3.703055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2.068615,
      2,
      5,
      1,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      1,
      3,
      0.639079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.911604,
      0,
      1.890478,
      0.743587,
      0,
      0.174651,
      NULL,
      3,
      1.854482,
      0,
      0.017234,
      0,
      0.665999,
      1,
      NULL,
      NULL,
      1.452375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '2223',
      '',
      '',
      1.692405,
      3,
      1.370972,
      0.239614,
      0.956040,
      3,
      0,
      NULL,
      3);
commit;
end;
/


