set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '230',
      '24112000',
      15,
      12.296165,
      '0224432',
      56,
      3,
      NULL,
      3,
      '022321',
      4,
      '10-18-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.927418,
      0.439141,
      0.409260,
      1,
      1.349783,
      NULL,
      5.200814,
      0.634651,
      0.661189,
      1.248305,
      0.744750,
      2.599265,
      NULL,
      0.438069,
      5.431324,
      1.303927,
      1.436315,
      NULL,
      NULL,
      1,
      0,
      0.947461,
      NULL,
      1,
      NULL,
      NULL,
      1.580992,
      NULL,
      NULL,
      4.731368,
      NULL,
      2,
      1.096662,
      0,
      1,
      2.032958,
      0,
      0.127669,
      0,
      3.579850,
      1,
      0,
      1.690983,
      3.612149,
      3.115070,
      3.820133,
      1.864939,
      0,
      1.526299,
      4.203949,
      0.534183,
      NULL,
      0,
      0,
      1.448945,
      1.963495,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.693727,
      1.283325,
      2,
      0.289125,
      NULL,
      0,
      1.135189,
      1,
      1,
      NULL,
      0,
      1.926546,
      1,
      0.624646,
      1,
      0.047826,
      1,
      0,
      1.453135,
      NULL,
      1,
      1,
      1,
      1,
      1.672213,
      NULL,
      1.386929,
      2.218540,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.639955,
      1,
      5.272285,
      1,
      9,
      4,
      1,
      0,
      4.733544,
      4,
      3.512245,
      1.734644,
      3.735407,
      NULL,
      NULL,
      1,
      5.328086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.887981,
      1.805875,
      0.485116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.807480,
      NULL,
      0.523341,
      0.905839,
      2.692636,
      1.217055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      6,
      NULL,
      2,
      2,
      5,
      NULL,
      NULL,
      NULL,
      0.517925,
      1.223017,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.715270,
      1.429922,
      0,
      2,
      NULL,
      0,
      2,
      1.230099,
      1,
      0.583091,
      0,
      NULL,
      1.608377,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '21131',
      NULL,
      '',
      0.183062,
      '',
      NULL,
      '',
      5,
      '14424',
      '0414',
      '',
      NULL,
      2,
      NULL,
      1.368692,
      1.630768,
      1,
      0.909916,
      3,
      0.252445);
commit;
end;
/


