set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '103',
      '23331302',
      1,
      70,
      '0322203',
      11,
      5,
      2.881407,
      3,
      '431434',
      0,
      ' 6-14-2003',
      53.290299,
      NULL,
      0.015402,
      NULL,
      1,
      1.886113,
      NULL,
      0.001262,
      0.808858,
      2.130400,
      1.106628,
      1,
      1,
      1.872210,
      2,
      1,
      1.216767,
      0,
      NULL,
      NULL,
      4,
      1,
      4.374964,
      2.985795,
      1,
      NULL,
      0.773682,
      0,
      5,
      NULL,
      0.016201,
      1.214794,
      NULL,
      NULL,
      0.141612,
      2,
      4,
      4.153770,
      0.889664,
      4.277461,
      3,
      1.825704,
      1,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3.907281,
      0,
      1.532839,
      0,
      0.498389,
      3,
      3,
      6,
      1,
      2,
      3.480887,
      1,
      NULL,
      NULL,
      2,
      5,
      0.135611,
      NULL,
      1.328202,
      1.256425,
      0.330151,
      3.942769,
      1.921780,
      0,
      0.063367,
      NULL,
      0,
      1.852763,
      0,
      1.769269,
      0.287448,
      1.525641,
      0.419548,
      1,
      0,
      1,
      NULL,
      1.884295,
      1,
      1.733841,
      1.728768,
      1.199082,
      0,
      0.994107,
      0,
      2,
      NULL,
      3.364711,
      3.851836,
      NULL,
      3,
      6.231632,
      0,
      0.500680,
      2,
      5,
      NULL,
      9.038720,
      NULL,
      5.912042,
      3.271879,
      4,
      1,
      9.756593,
      6.037406,
      1.994298,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334375,
      0,
      0,
      0,
      1.279658,
      1.300020,
      0.704832,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.565031,
      NULL,
      0,
      1.709172,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974760,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4.097023,
      2.295587,
      NULL,
      NULL,
      0,
      1,
      6.524759,
      0.264956,
      NULL,
      NULL,
      0,
      0.473492,
      3,
      5.015180,
      5,
      NULL,
      4.790433,
      3.040412,
      0,
      0,
      3,
      2.653994,
      0.194828,
      NULL,
      1.187111,
      NULL,
      2.821970,
      1.201275,
      NULL,
      0.383120,
      1.263567,
      NULL,
      1,
      1,
      NULL,
      0,
      1.926653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '',
      '',
      1.445493,
      '',
      '',
      '',
      2,
      '4400',
      '44111',
      '',
      3,
      3,
      2,
      3,
      3.071026,
      1.380408,
      3.039686,
      2,
      2);
commit;
end;
/


