set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '14114114',
      8,
      61.178152,
      '4201322',
      194,
      0,
      0.020162,
      0,
      '103144',
      4.653448,
      ' 6-16-1994',
      30,
      47,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0.450207,
      0.646839,
      0,
      1.409748,
      0.456538,
      NULL,
      NULL,
      1,
      NULL,
      8,
      0.534572,
      0,
      0.754219,
      0.610357,
      NULL,
      3.382614,
      0,
      1.220743,
      1.232639,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      0.585064,
      5,
      0.267891,
      1.969262,
      NULL,
      0,
      3.537623,
      0.581521,
      NULL,
      0.046406,
      0.617536,
      NULL,
      2,
      1,
      1.709673,
      0,
      0.677700,
      1.005559,
      2,
      2.488685,
      4,
      4.213762,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      1,
      NULL,
      1.099836,
      NULL,
      NULL,
      1,
      0,
      1.962642,
      0,
      1,
      0.842589,
      1.015132,
      1.125751,
      0.408292,
      0.441787,
      NULL,
      0,
      NULL,
      NULL,
      0.025067,
      0.822823,
      1.002205,
      0.202278,
      NULL,
      0.965163,
      NULL,
      2.432141,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.230456,
      1.934667,
      NULL,
      4,
      NULL,
      1.866885,
      7,
      2.761266,
      2,
      2.191810,
      0,
      6,
      2,
      2.701773,
      3.594174,
      1.077038,
      0,
      1.590719,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.175369,
      1,
      1,
      0,
      1.455201,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.220208,
      NULL,
      4,
      0,
      2,
      1.560892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.873055,
      0,
      NULL,
      0.818291,
      0.269966,
      0,
      2.362180,
      NULL,
      3,
      3,
      1,
      2,
      5.806276,
      0.832915,
      NULL,
      NULL,
      2.801055,
      9.032130,
      1.509535,
      NULL,
      2,
      2.162195,
      NULL,
      1.146608,
      0.785390,
      NULL,
      1,
      2.378506,
      2.379575,
      2.575832,
      NULL,
      0.633683,
      3.832055,
      0,
      1.778740,
      2.509167,
      0.651614,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.391758,
      0.613381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415778,
      '02133',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '1222',
      '00211',
      '',
      1,
      3.225801,
      1.598591,
      0.852953,
      2.868695,
      1,
      2,
      3.311488,
      1);
commit;
end;
/


