set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      '43214403',
      NULL,
      7,
      NULL,
      197,
      5,
      0,
      0,
      '022130',
      0,
      NULL,
      31,
      0,
      NULL,
      NULL,
      1.565287,
      1.013756,
      0,
      NULL,
      0.718342,
      0.911058,
      NULL,
      0.101497,
      NULL,
      NULL,
      NULL,
      1.990957,
      0.865175,
      1,
      NULL,
      NULL,
      NULL,
      0,
      7.113440,
      3.431539,
      1.934603,
      2,
      1.369215,
      1,
      1,
      1.569733,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.399720,
      0.138573,
      6,
      NULL,
      1.248799,
      0.347134,
      3,
      2.952416,
      1,
      3.027617,
      3.546922,
      1,
      NULL,
      3,
      3.981793,
      1.762965,
      1.797324,
      1,
      0.422283,
      3.607543,
      3.356666,
      8.159242,
      4.554850,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419638,
      1.729135,
      0.458101,
      0,
      1,
      0.718040,
      0.330838,
      0.436871,
      0.633385,
      1.678701,
      1.151633,
      0,
      1,
      1.069532,
      NULL,
      1.007843,
      1,
      NULL,
      NULL,
      0.065819,
      3,
      0,
      1,
      2.348300,
      0.886298,
      5,
      3.743969,
      NULL,
      NULL,
      NULL,
      NULL,
      6.257580,
      0.246706,
      NULL,
      NULL,
      4,
      8.444107,
      NULL,
      0.988085,
      4,
      9.090903,
      6,
      2.579018,
      1,
      0,
      NULL,
      4.524582,
      2,
      0,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625019,
      NULL,
      1,
      0,
      1.803600,
      1,
      1.674811,
      0.636592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      1.617508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.166221,
      1,
      2.884486,
      1.664290,
      3,
      1,
      0,
      0,
      5,
      5,
      4.468370,
      0,
      3.676778,
      NULL,
      NULL,
      NULL,
      2.853547,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      1,
      NULL,
      0,
      3.059933,
      0,
      2,
      3.213481,
      0.663710,
      1,
      0.917567,
      0,
      1,
      1.549196,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '32220',
      '',
      '',
      1,
      '',
      NULL,
      '',
      7.702571,
      NULL,
      NULL,
      '10343',
      NULL,
      0.872800,
      NULL,
      3.782542,
      2,
      2.300055,
      2,
      NULL,
      3);
commit;
end;
/


