set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24411413',
      NULL,
      71,
      '4400242',
      NULL,
      0,
      1,
      1,
      '102313',
      NULL,
      '11-27-2000',
      46.135313,
      38.764865,
      1.533126,
      NULL,
      NULL,
      1,
      NULL,
      0.439594,
      1.312079,
      1,
      0,
      1.462391,
      0,
      1.498156,
      3,
      NULL,
      1,
      1.733424,
      0.516569,
      0,
      5,
      NULL,
      5,
      3.173641,
      1.341359,
      1.587547,
      5.708048,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.373159,
      NULL,
      NULL,
      3.698072,
      1,
      5,
      2.639614,
      1.410867,
      NULL,
      2,
      NULL,
      NULL,
      0.072496,
      3.198121,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.968885,
      1,
      1.264303,
      1.981068,
      5,
      NULL,
      9.470897,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551372,
      2.004965,
      3,
      1,
      0.879160,
      0,
      0.874721,
      1.839058,
      1.208830,
      0.150153,
      1,
      NULL,
      1.904283,
      1,
      1.084023,
      NULL,
      0.995402,
      NULL,
      0.778415,
      NULL,
      NULL,
      0.295417,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.351310,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.168009,
      3.825917,
      0,
      2,
      7.410874,
      4,
      1.312655,
      1.527777,
      4,
      1.301599,
      9.951421,
      5.429351,
      5,
      0.450940,
      1.396895,
      1.347429,
      0,
      NULL,
      3.162244,
      0.456696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.626026,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.845403,
      3.025717,
      1.590070,
      1.662526,
      1.438603,
      2,
      NULL,
      8.384484,
      1.787834,
      4,
      NULL,
      2.971191,
      1.438336,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.437903,
      3.689777,
      0.423546,
      NULL,
      2,
      0,
      2,
      1,
      2.306588,
      1.295334,
      1.836437,
      NULL,
      0,
      NULL,
      1.121561,
      1.359151,
      0.710429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '',
      '',
      0.362991,
      NULL,
      '',
      '',
      0.443402,
      NULL,
      '33123',
      NULL,
      5.985690,
      0.600085,
      2,
      1,
      3.012226,
      5,
      1,
      1,
      1);
commit;
end;
/


