set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03434322',
      67.375787,
      65,
      NULL,
      NULL,
      5,
      2,
      2,
      '134402',
      1,
      ' 4-18-1989',
      NULL,
      9.749006,
      0,
      NULL,
      1.240955,
      1.226136,
      NULL,
      1,
      1,
      NULL,
      1,
      0.351960,
      0,
      0.906749,
      1,
      0,
      0,
      0.825232,
      1.141476,
      0,
      NULL,
      1.296034,
      0,
      0,
      0,
      1.065814,
      5,
      0,
      2.646350,
      NULL,
      1.854675,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      6.953659,
      2,
      0,
      0.084434,
      1.133645,
      NULL,
      1,
      NULL,
      2.545800,
      0.824184,
      1.778874,
      0.546959,
      NULL,
      NULL,
      3.011913,
      1.784877,
      NULL,
      3,
      3.741636,
      NULL,
      9,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.268470,
      2,
      3.509958,
      NULL,
      2.303469,
      1,
      0,
      0.456841,
      1.913546,
      0,
      1,
      0,
      1,
      0.402771,
      NULL,
      0.411444,
      0,
      1,
      1,
      NULL,
      1.489546,
      1,
      NULL,
      0,
      1,
      1.410580,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420620,
      0.280588,
      2,
      NULL,
      3,
      7,
      5,
      6,
      6.899342,
      1,
      7,
      4,
      NULL,
      4.572684,
      0,
      4,
      NULL,
      1.198596,
      1.270251,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016176,
      1,
      0,
      0,
      1,
      1.786676,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.739888,
      1,
      3,
      0.479584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.401029,
      0.584493,
      2,
      NULL,
      0,
      2,
      5.974055,
      1.372940,
      NULL,
      0.883724,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.479556,
      1.339201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688060,
      1.225756,
      0.712211,
      NULL,
      NULL,
      3.917547,
      0,
      2.915448,
      0,
      3,
      3.295636,
      1,
      0,
      NULL,
      0.498040,
      NULL,
      NULL,
      1,
      1.289966,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.207254,
      '31032',
      '',
      '',
      0.874017,
      '',
      '',
      '',
      5.930488,
      NULL,
      '23312',
      '01314',
      0,
      5.087138,
      0,
      1,
      0.529753,
      NULL,
      NULL,
      3,
      NULL);
commit;
end;
/


