set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2242',
      '42421002',
      21.994693,
      13,
      '1143222',
      115,
      1,
      1.455314,
      2,
      NULL,
      1,
      ' 6- 5-1986',
      50,
      52,
      0,
      NULL,
      0.164512,
      1,
      0.341873,
      0.857217,
      0.351523,
      0.689789,
      NULL,
      0,
      0.256466,
      NULL,
      4,
      NULL,
      1,
      0,
      1,
      0.987786,
      6.925438,
      1.198461,
      2.155291,
      0,
      1.933784,
      0.047910,
      3.983459,
      0,
      NULL,
      0,
      2.483574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.962748,
      0.622378,
      8.889852,
      0.857499,
      1,
      1,
      3,
      2,
      0,
      2.499239,
      NULL,
      1.029095,
      1,
      NULL,
      2.375730,
      1,
      2,
      0,
      1,
      2,
      9.121089,
      4,
      0,
      NULL,
      0,
      2.517022,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.249201,
      NULL,
      NULL,
      0.034283,
      1,
      0,
      0,
      0,
      NULL,
      0.901124,
      1,
      1.544914,
      NULL,
      0,
      0.107565,
      0,
      0,
      1,
      0,
      NULL,
      1.742657,
      NULL,
      1,
      0,
      0,
      1.736534,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.129761,
      0,
      1,
      1,
      3,
      4.759735,
      4,
      4.220180,
      NULL,
      4,
      3.714254,
      8.176303,
      4,
      2.931416,
      1.675923,
      1,
      NULL,
      0.060607,
      1.911312,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.304824,
      1.862679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.743833,
      1,
      3.894128,
      3,
      NULL,
      3.424659,
      0.010084,
      1.301360,
      3.151391,
      1.743330,
      1,
      0,
      NULL,
      NULL,
      0.580114,
      2,
      0.528508,
      3,
      0,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.430510,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139870,
      0.561513,
      3,
      3.398434,
      NULL,
      1,
      0.475823,
      1,
      1.538208,
      0,
      NULL,
      NULL,
      NULL,
      0.408642,
      1.390324,
      1.472694,
      0.581616,
      1,
      1.792132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.349452,
      '04310',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3,
      '3240',
      '03420',
      '20440',
      4.577428,
      3,
      2,
      3,
      1.903679,
      NULL,
      3.117070,
      1,
      2);
commit;
end;
/


