set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0301',
      '11323144',
      38,
      NULL,
      '3004104',
      200.205477,
      5,
      0,
      NULL,
      '432110',
      5.735525,
      ' 0-27-1974',
      25,
      55,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.122603,
      NULL,
      NULL,
      0.715976,
      0.998351,
      1,
      1.746130,
      1.273548,
      NULL,
      0.747614,
      0.318842,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      2,
      1.078431,
      0,
      1.511561,
      NULL,
      NULL,
      1.695664,
      NULL,
      NULL,
      8.759853,
      1,
      5.035574,
      NULL,
      1.748956,
      NULL,
      2,
      1.191339,
      0.323903,
      NULL,
      0.551448,
      1,
      NULL,
      NULL,
      2.396477,
      0.186595,
      0,
      NULL,
      NULL,
      4.946929,
      7.574613,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458029,
      0.173325,
      1,
      NULL,
      1.599853,
      0.319510,
      1.342041,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176379,
      0,
      1.012450,
      1.649672,
      1.588738,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0.729094,
      NULL,
      0.445086,
      0.317197,
      0.274625,
      NULL,
      1.578982,
      1.196715,
      3,
      0.564704,
      1,
      3.855443,
      0,
      NULL,
      1,
      5.989973,
      9,
      NULL,
      1.204998,
      2,
      8.670155,
      7.171060,
      3,
      NULL,
      1,
      1.414692,
      0.889288,
      NULL,
      6,
      0.124044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0.811294,
      1,
      0.872782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.320485,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.773167,
      NULL,
      3.132688,
      NULL,
      2,
      3,
      4,
      NULL,
      9.416980,
      6.359147,
      2.098706,
      1,
      0.199926,
      NULL,
      NULL,
      NULL,
      1.881598,
      6.896345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417044,
      3,
      NULL,
      1,
      0,
      1,
      0,
      3.089350,
      1.145401,
      0,
      3.298456,
      1,
      1,
      NULL,
      1.107868,
      0.146573,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.086908,
      '13434',
      '',
      '',
      0.242772,
      NULL,
      '',
      NULL,
      6,
      NULL,
      '21424',
      '31314',
      0,
      3,
      1,
      2.225931,
      1.602260,
      NULL,
      3,
      0.143088,
      1.263995);
commit;
end;
/


