set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '4412140',
      4,
      6,
      1.878184,
      3,
      '012011',
      1.154018,
      ' 4-10-1994',
      0.568942,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.552886,
      1.923664,
      1.239015,
      NULL,
      NULL,
      1,
      3.458958,
      1,
      5,
      NULL,
      NULL,
      3,
      NULL,
      0,
      4.785317,
      1,
      1,
      1.522060,
      0,
      NULL,
      4.548056,
      1,
      5,
      NULL,
      0,
      1.578596,
      NULL,
      NULL,
      1.367297,
      NULL,
      NULL,
      NULL,
      1.489101,
      0.458723,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776867,
      1,
      7,
      NULL,
      0,
      0,
      0.624691,
      0.925683,
      NULL,
      NULL,
      0.488085,
      NULL,
      NULL,
      0.053940,
      1,
      1,
      NULL,
      NULL,
      1.363045,
      1.378703,
      0.558877,
      1.823283,
      NULL,
      1.286188,
      NULL,
      0.010365,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0.852657,
      0.598746,
      NULL,
      NULL,
      1.916801,
      1,
      NULL,
      1,
      1.857341,
      0.472130,
      1,
      0,
      NULL,
      0.678960,
      NULL,
      3,
      0,
      6.135219,
      3.670106,
      NULL,
      0,
      2.703918,
      NULL,
      NULL,
      NULL,
      NULL,
      2.725214,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062851,
      1,
      0,
      1.030622,
      0,
      0.646077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.025183,
      NULL,
      2.516117,
      NULL,
      2.025512,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.249546,
      1,
      0,
      1.914350,
      1,
      1.102474,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.935230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.756577,
      1,
      0.187824,
      NULL,
      NULL,
      0,
      0,
      1.152203,
      NULL,
      1,
      0.940313,
      0.266667,
      0,
      1,
      1,
      0,
      NULL,
      1.308267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.522508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612829,
      NULL,
      NULL,
      NULL,
      NULL,
      0.056144,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.367162,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      '40403',
      '',
      '',
      1,
      '',
      '',
      '',
      1.924455,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


