set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      20.305419,
      5,
      1,
      3,
      '120010',
      1,
      '11-23-1985',
      55,
      NULL,
      0,
      NULL,
      2,
      0,
      1,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      1.618171,
      NULL,
      0.606901,
      1,
      3.268647,
      2,
      1.727381,
      NULL,
      1,
      1.957164,
      1,
      1,
      0.336283,
      4.061830,
      1,
      2.102610,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.143882,
      NULL,
      NULL,
      1.398385,
      0.153622,
      1,
      1.471614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095258,
      0.203942,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986692,
      NULL,
      0,
      1.530587,
      0,
      1,
      1.164903,
      1.900173,
      1.524740,
      0.185594,
      1.274017,
      0,
      1.320528,
      0.387213,
      0.559333,
      0,
      1.514346,
      0.304899,
      0,
      NULL,
      0,
      0.633641,
      1.796053,
      0,
      1,
      NULL,
      0,
      2.939652,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444608,
      1.812112,
      0,
      1,
      1.367638,
      2.599894,
      6.320426,
      4,
      3.146593,
      1.729249,
      4,
      1.165497,
      4,
      NULL,
      10.364055,
      0.711209,
      0.940704,
      NULL,
      NULL,
      1.188195,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994505,
      1,
      1,
      0,
      0.905137,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8.379820,
      2.374897,
      2,
      1.643606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.580021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358635,
      NULL,
      2,
      1,
      0.799832,
      1.446541,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.426295,
      2.188023,
      0.315629,
      3,
      NULL,
      0.336813,
      1,
      NULL,
      1.174799,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.247982,
      0.161746,
      1,
      0.790905,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.213723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.595500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504886,
      NULL,
      NULL,
      NULL,
      NULL,
      0.741727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.893759,
      NULL,
      0.681698,
      1,
      0,
      2,
      3,
      NULL,
      '',
      '',
      0.429061,
      '',
      '',
      NULL,
      0.215994,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


