set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '100',
      '24202304',
      15,
      46,
      '2333342',
      12.852634,
      NULL,
      2.487588,
      1,
      '031112',
      3,
      ' 9-17-1994',
      72,
      NULL,
      1.266210,
      NULL,
      3,
      NULL,
      1,
      0,
      1.293243,
      NULL,
      1.957299,
      0.361361,
      3,
      0,
      0.516816,
      0.543434,
      0.838712,
      NULL,
      NULL,
      0.893177,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.822056,
      0.027907,
      0,
      0.446212,
      1,
      1,
      1,
      2,
      1,
      0,
      0.605278,
      0.007751,
      0.708292,
      NULL,
      NULL,
      1.428144,
      1.968694,
      3.675898,
      2,
      1.507984,
      1.468855,
      1.732704,
      4,
      1,
      NULL,
      2.722546,
      1,
      NULL,
      NULL,
      0.256417,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.831391,
      1.066644,
      1,
      NULL,
      0,
      NULL,
      0,
      0.819561,
      0.851790,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424742,
      0,
      1.339971,
      1,
      NULL,
      1.813504,
      NULL,
      NULL,
      0.438100,
      NULL,
      1,
      1,
      4,
      NULL,
      4.984498,
      5.864772,
      2.043924,
      1.563366,
      1.853539,
      0,
      4,
      4.286056,
      NULL,
      1.800947,
      0.957128,
      0,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.308679,
      0,
      1,
      1,
      1,
      0,
      0.933829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.605252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357698,
      1,
      1.334791,
      0,
      1.580155,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.765801,
      1.932324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243630,
      0,
      3.740454,
      2.614144,
      2.199914,
      NULL,
      0,
      NULL,
      1.990075,
      3,
      1.050707,
      1.750702,
      0.476866,
      1.803436,
      NULL,
      1,
      0,
      1.274837,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      5,
      2.856087,
      0.517030,
      3,
      2.353376,
      2,
      NULL,
      2.952760,
      0);
commit;
end;
/


