set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      '43333242',
      35,
      0,
      '4432110',
      177,
      4,
      2.642466,
      NULL,
      '234134',
      NULL,
      ' 2- 0-1978',
      13.906481,
      12,
      0.793432,
      NULL,
      2,
      1,
      3.474401,
      1.855782,
      NULL,
      NULL,
      0.889253,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.058556,
      1,
      3.732354,
      1.026894,
      2,
      0,
      1,
      0.305221,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.711186,
      0.369094,
      1,
      3,
      0.514811,
      0,
      0.297929,
      2.319485,
      0,
      2,
      1,
      NULL,
      1.431999,
      NULL,
      0,
      1,
      0,
      3,
      3.753059,
      NULL,
      1.253599,
      3,
      1.954108,
      1,
      1,
      3,
      1.180889,
      NULL,
      NULL,
      1.176277,
      NULL,
      NULL,
      0.984121,
      0,
      1.448273,
      1,
      1,
      0.382029,
      0,
      NULL,
      0.476477,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.986599,
      NULL,
      NULL,
      0.643216,
      2,
      0,
      1.718071,
      0.253838,
      4.719164,
      1.851340,
      0.102053,
      NULL,
      0,
      3,
      0.491163,
      1,
      2,
      NULL,
      1,
      2.422790,
      NULL,
      2,
      5.938950,
      NULL,
      1,
      8.569546,
      NULL,
      NULL,
      3,
      3,
      0.014778,
      NULL,
      NULL,
      NULL,
      1.732538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773953,
      1.481705,
      1,
      0,
      1,
      4.790307,
      0,
      2.784317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      0,
      2.396128,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      0.194784,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.326117,
      2,
      3.261100,
      1,
      1.522096,
      NULL,
      NULL,
      2,
      1.418167,
      0,
      1,
      1.278591,
      1.411534,
      0,
      1.621341,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      NULL,
      0,
      1.877797,
      0,
      0.587441,
      NULL,
      1,
      1.548306,
      2);
commit;
end;
/


