set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10004443',
      57,
      NULL,
      '4101200',
      NULL,
      6,
      2,
      1,
      NULL,
      2.527004,
      '11-23-1988',
      101,
      144,
      NULL,
      NULL,
      1,
      1,
      2.467556,
      1.634836,
      1.306160,
      0.500222,
      NULL,
      0.012167,
      2.618429,
      1,
      0.598022,
      1,
      0.027988,
      1.183688,
      1.378088,
      0,
      NULL,
      1.217389,
      1.046095,
      1,
      NULL,
      1,
      4.881529,
      0,
      3.988516,
      0,
      1.857977,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.726932,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.782326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.155625,
      0,
      1,
      NULL,
      NULL,
      1.968695,
      1,
      1,
      NULL,
      1.081849,
      1.481515,
      0,
      NULL,
      0,
      NULL,
      1.309613,
      0.009418,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.756051,
      1,
      0.987710,
      NULL,
      1,
      1,
      0.649228,
      0.691327,
      NULL,
      NULL,
      1.371043,
      1.984218,
      0.300363,
      0.995990,
      0,
      NULL,
      0.072211,
      1,
      NULL,
      NULL,
      NULL,
      0.954707,
      1.546412,
      6.741576,
      4,
      0,
      NULL,
      NULL,
      3,
      0.871857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763100,
      0.592263,
      0,
      0,
      0,
      0,
      0.250660,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234744,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816934,
      NULL,
      1,
      0.110721,
      1.636325,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.452016,
      1.756667,
      0.094459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.626552,
      1,
      0,
      1,
      0,
      NULL,
      0.210789,
      0,
      1.784024,
      0,
      1,
      NULL,
      NULL,
      1.718371,
      0,
      0,
      1.377093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.907359,
      '11242',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.820070,
      NULL,
      '',
      NULL,
      1,
      NULL,
      2.253479,
      2.708207,
      3,
      NULL,
      NULL,
      3.155845,
      3.780328);
commit;
end;
/


