set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '40',
      24.916662,
      22,
      '1033130',
      58.852013,
      5,
      1,
      2,
      NULL,
      5,
      '11-10-1990',
      26.165045,
      70,
      NULL,
      NULL,
      1,
      2,
      1.157110,
      NULL,
      1,
      1.311897,
      3,
      0.894486,
      1.857088,
      1,
      1.937897,
      1,
      1.504980,
      1.307188,
      0.521505,
      0.909857,
      NULL,
      1,
      0.446301,
      0.129423,
      1,
      0,
      0.744701,
      1,
      NULL,
      0.720518,
      1.214076,
      0.867143,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.830108,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231978,
      0.703668,
      0.717335,
      0.513898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.302065,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1.760651,
      1.118521,
      0.352329,
      1.552749,
      1,
      0.463564,
      0,
      1,
      1.711241,
      1.593311,
      1.348713,
      NULL,
      NULL,
      0,
      0.831315,
      0.052251,
      1.644141,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      0.577439,
      1,
      1.160397,
      2,
      NULL,
      0,
      1,
      0.686726,
      1.657257,
      0.160205,
      NULL,
      NULL,
      3.876136,
      1.833715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.245471,
      1,
      1,
      NULL,
      0.235504,
      1.551942,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925225,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.214564,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219532,
      NULL,
      1,
      0.989311,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797108,
      0.530343,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762191,
      2,
      1,
      1,
      0.060572,
      0,
      0,
      NULL,
      1,
      1.124938,
      1.056102,
      1,
      1,
      NULL,
      1.666207,
      NULL,
      1.603531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233762,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      0.483697,
      2,
      3.371511,
      '3240',
      '',
      '',
      0,
      '',
      '',
      '',
      0.786549,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


