set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      36.620333,
      '0412202',
      70.814588,
      6,
      NULL,
      1,
      '103220',
      5,
      ' 1-27-2000',
      30.972214,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420142,
      1,
      1.286449,
      1,
      0,
      1.614873,
      NULL,
      0.664448,
      1,
      0.899805,
      0,
      1,
      0.175602,
      0,
      1,
      0,
      NULL,
      0.823780,
      1,
      0.117930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589649,
      0.442684,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947814,
      1.251538,
      0,
      0.734386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.046394,
      0,
      NULL,
      NULL,
      NULL,
      0.825594,
      0,
      1,
      0.139714,
      0,
      1,
      1.334315,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.104112,
      NULL,
      0,
      0.221200,
      1.989299,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.962882,
      NULL,
      2,
      1,
      1.337871,
      0.430520,
      3,
      0.775729,
      NULL,
      2.999040,
      3.970953,
      2.112075,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.895662,
      NULL,
      NULL,
      0.168187,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039616,
      1,
      1,
      0,
      1.049825,
      0,
      0.200690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860037,
      NULL,
      NULL,
      NULL,
      NULL,
      5.710409,
      2.386651,
      0,
      0.977994,
      0,
      NULL,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.170132,
      1,
      0,
      4.374009,
      1.255866,
      0,
      0.526985,
      NULL,
      NULL,
      NULL,
      0.967313,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.159776,
      0,
      1,
      0.846259,
      NULL,
      1.963629,
      0.199059,
      1,
      1.200740,
      1.945301,
      0.759520,
      0,
      0,
      0.611495,
      1.213178,
      1.130617,
      NULL,
      0,
      1.435259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.676004,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.914385,
      0.371431,
      1,
      NULL,
      0.388418,
      NULL,
      0.291300,
      NULL,
      1,
      '1233',
      '',
      '',
      0.990193,
      '',
      NULL,
      NULL,
      0.405408,
      NULL,
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


