set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '422',
      '12343230',
      15,
      33.195357,
      '2024002',
      33,
      NULL,
      2.540200,
      1,
      '312022',
      1.324938,
      NULL,
      11.072696,
      22,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.806098,
      1.183428,
      1.923010,
      3.394653,
      1.268135,
      NULL,
      1,
      1.968766,
      NULL,
      0.551062,
      0.989713,
      1,
      NULL,
      NULL,
      0.469968,
      NULL,
      1.929852,
      0.230000,
      0.899409,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614156,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.627449,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002498,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1.410492,
      1,
      0,
      0,
      NULL,
      1.953774,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1.467160,
      1.213957,
      NULL,
      1,
      0.079446,
      0,
      1.301716,
      1,
      1.176431,
      0,
      0.489203,
      1.951860,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.893050,
      1,
      3,
      NULL,
      0,
      4.264019,
      1,
      0.277208,
      1.467048,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665158,
      1,
      0,
      NULL,
      NULL,
      0,
      1.435170,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924861,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.395167,
      0,
      1,
      NULL,
      5,
      1,
      2,
      1,
      2,
      3,
      NULL,
      0,
      1,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.143285,
      1.083996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165078,
      1,
      1.783453,
      1,
      1,
      1,
      NULL,
      0,
      1.711470,
      1.877396,
      0,
      1,
      NULL,
      0.001306,
      1.148901,
      NULL,
      1.859199,
      1.705764,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.309106,
      NULL,
      1.160653,
      1,
      0,
      NULL,
      2.152518,
      '3201',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      2.307014,
      0.556933,
      2,
      2,
      0.885257,
      NULL,
      1.646958,
      2,
      3.528567);
commit;
end;
/


