set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00433012',
      NULL,
      64,
      NULL,
      62.330470,
      3,
      NULL,
      2,
      NULL,
      NULL,
      ' 2-20-1999',
      7,
      24.478753,
      NULL,
      NULL,
      0.918306,
      2.171460,
      0.970317,
      NULL,
      0.149764,
      NULL,
      0.849567,
      1,
      0.373793,
      0,
      3.125571,
      0,
      1.300574,
      NULL,
      1.557690,
      1,
      2.406645,
      1,
      0,
      1,
      NULL,
      1,
      3,
      0,
      4.331856,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.283863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955721,
      NULL,
      0.721949,
      0.227557,
      0.126655,
      NULL,
      0.456576,
      0.485748,
      0.128092,
      0,
      0.597001,
      0,
      1,
      0,
      0.016858,
      1,
      0.328603,
      1,
      1,
      NULL,
      1.877263,
      1.520532,
      0.233155,
      1.294289,
      0.233339,
      1,
      0.902153,
      0,
      1.390985,
      NULL,
      NULL,
      4.801801,
      0.283424,
      NULL,
      NULL,
      0,
      1.886578,
      1.962549,
      2.111314,
      1.193557,
      0,
      7.843086,
      NULL,
      0,
      5,
      NULL,
      3,
      2,
      1.923027,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.446943,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.177477,
      1,
      4.950423,
      2,
      2.316408,
      1.894002,
      1,
      2,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.378929,
      0,
      0.752031,
      6.346977,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.719894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751536,
      NULL,
      1.100790,
      NULL,
      2,
      0.245456,
      1.516988,
      NULL,
      1,
      2,
      0.031096,
      1.843722,
      1.465600,
      1,
      1.963692,
      0.630727,
      0,
      0.099026,
      0.269979,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.929318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885789,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725216,
      NULL,
      0.384806,
      NULL,
      1.355006,
      0,
      NULL,
      1,
      1.101030,
      '1021',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      0.216290,
      '2421',
      '',
      '',
      3.503975,
      3,
      1,
      1,
      2.127803,
      3,
      3.013926,
      NULL,
      3.179387);
commit;
end;
/


