set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '200',
      '22230003',
      27,
      27.497492,
      '2213030',
      77,
      5,
      NULL,
      0,
      '314120',
      NULL,
      ' 4-14-1985',
      NULL,
      59,
      1,
      NULL,
      NULL,
      3.810422,
      1.665304,
      0,
      NULL,
      0.045258,
      1.310637,
      NULL,
      1.533204,
      0.983249,
      0.028022,
      0.028060,
      0,
      0.091220,
      NULL,
      1.390065,
      4.360872,
      1,
      1.850812,
      0.377279,
      0,
      1.540214,
      2.825213,
      1,
      4.153758,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920113,
      1.062219,
      0.086044,
      1.299351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964949,
      0.029371,
      1.763409,
      0.179512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496602,
      1.273218,
      NULL,
      0.466555,
      NULL,
      1,
      1.457914,
      NULL,
      0.698774,
      0,
      0,
      NULL,
      0.128970,
      1,
      1.044165,
      0.826602,
      0.856635,
      1.812572,
      NULL,
      1.248007,
      1.036761,
      0.992916,
      0,
      1,
      0,
      1.027522,
      1.109913,
      0,
      1.476025,
      1,
      2.220176,
      1.933604,
      NULL,
      1.200405,
      NULL,
      NULL,
      0,
      1.946152,
      3,
      5,
      9.915639,
      NULL,
      4.161813,
      6,
      1,
      1.095239,
      1.318100,
      0.435591,
      NULL,
      NULL,
      6,
      0.482411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488295,
      0.061377,
      1,
      0,
      0,
      1.783889,
      1,
      1.957719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.263490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.215727,
      NULL,
      1,
      5,
      1,
      NULL,
      1.275087,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.553964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      1.776585,
      0.914912,
      NULL,
      NULL,
      0,
      0.241804,
      0,
      0,
      0.681945,
      0,
      1,
      0,
      0.249210,
      1.077325,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.309416,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.072011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.912984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840457,
      NULL,
      NULL,
      NULL,
      NULL,
      2.015483,
      2.728457,
      0.883348,
      NULL,
      1.762116,
      1.354117,
      1.021910,
      2,
      2.875162,
      '4031',
      NULL,
      NULL,
      0.498862,
      '',
      '',
      '',
      NULL,
      '2422',
      '',
      NULL,
      5,
      2,
      3.066354,
      1.495218,
      0.442602,
      2,
      1,
      3,
      1);
commit;
end;
/


