set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '421',
      NULL,
      24.461587,
      27,
      NULL,
      148.004456,
      NULL,
      3.820470,
      1,
      '313022',
      NULL,
      NULL,
      40.214636,
      41.493740,
      0,
      NULL,
      1,
      3,
      1.589075,
      1.512539,
      0,
      NULL,
      1,
      0,
      0.071201,
      0,
      NULL,
      1,
      0.085487,
      NULL,
      NULL,
      1.404922,
      2.036386,
      0,
      NULL,
      0.033386,
      1,
      1,
      4,
      1,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.548292,
      0.318706,
      NULL,
      0,
      0.630742,
      0,
      1,
      1.124130,
      1,
      0,
      1.056106,
      1.740178,
      1.850297,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      0.409182,
      1,
      1.341011,
      1,
      NULL,
      0,
      NULL,
      1.153889,
      5.416931,
      0,
      NULL,
      NULL,
      1.764357,
      0.412351,
      0.555830,
      1.354661,
      3,
      3,
      1.845727,
      NULL,
      0.593146,
      NULL,
      0.863833,
      0,
      0,
      1.407497,
      NULL,
      NULL,
      NULL,
      1.058579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750288,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.910472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.249095,
      1.394221,
      1,
      NULL,
      0,
      0,
      1.084662,
      NULL,
      NULL,
      NULL,
      1,
      0.014866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.200781,
      1.818518,
      1.705048,
      0.906297,
      1,
      1.385639,
      0.020766,
      0,
      0,
      0.555218,
      0,
      1,
      0.487016,
      NULL,
      0.322459,
      0,
      NULL,
      0.632719,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380003,
      1.234151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265887,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475738,
      NULL,
      NULL,
      NULL,
      NULL,
      3.514187,
      NULL,
      1,
      NULL,
      0.592920,
      1.791245,
      1,
      NULL,
      3,
      '2423',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '0003',
      '',
      '',
      NULL,
      5,
      NULL,
      3.241601,
      3,
      NULL,
      2,
      3.969762,
      3);
commit;
end;
/


