set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1341',
      '30114132',
      74,
      NULL,
      '3332101',
      61,
      5,
      NULL,
      1,
      '114113',
      5.974720,
      ' 5-14-1998',
      15.510276,
      51,
      0,
      NULL,
      NULL,
      2.474669,
      1,
      1.575206,
      1,
      1.036688,
      1.041784,
      1,
      NULL,
      NULL,
      4.628123,
      0.824959,
      0,
      0,
      1.609707,
      NULL,
      6.200344,
      0.434768,
      1,
      0,
      1,
      0,
      2,
      1,
      1.314798,
      1.043958,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.750445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      1.537441,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.201790,
      1.688540,
      1.087914,
      0.754012,
      NULL,
      0.879254,
      1.263401,
      1,
      0.124967,
      0,
      0,
      1,
      1.663808,
      1,
      0.231132,
      0,
      1.606487,
      1,
      NULL,
      0.650760,
      NULL,
      0,
      1.409376,
      1,
      0,
      1.932403,
      NULL,
      0.926165,
      1.847119,
      2,
      3.797963,
      0.964047,
      1.742057,
      3.995168,
      0.151556,
      0.018945,
      0.256912,
      0,
      1,
      0.008286,
      7.385761,
      5,
      0.147696,
      0,
      0.409828,
      0.468681,
      0,
      1.358708,
      NULL,
      NULL,
      9.726305,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.375478,
      NULL,
      1,
      1,
      NULL,
      1.631329,
      0.498340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911575,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.808835,
      NULL,
      0,
      1.412902,
      NULL,
      NULL,
      NULL,
      1,
      0.605087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.492301,
      1,
      1,
      0,
      NULL,
      1.490396,
      0.423581,
      0.581624,
      0,
      1,
      1.753953,
      0.370721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '12223',
      '',
      '',
      1.973545,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '',
      5.163285,
      NULL,
      NULL,
      3,
      3,
      0.472540,
      1,
      3,
      0);
commit;
end;
/


