set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422857';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '1134122',
      14.100504,
      3,
      1.638155,
      2,
      '013430',
      1,
      ' 7- 0-1990',
      3.286726,
      NULL,
      1,
      NULL,
      0.510611,
      2,
      1.620016,
      0,
      0,
      0,
      0,
      1,
      1.165866,
      NULL,
      NULL,
      NULL,
      1,
      3.224856,
      2.967896,
      1.854419,
      6.326225,
      1,
      0,
      NULL,
      NULL,
      1,
      7.042529,
      1,
      3,
      NULL,
      0.288800,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.027382,
      1,
      1.009868,
      1.842527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.313462,
      1.670966,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670555,
      NULL,
      0.016311,
      1.309474,
      NULL,
      3.110269,
      6.560951,
      NULL,
      0,
      1.518892,
      1.533713,
      1,
      1,
      4,
      1.228946,
      0,
      1.421465,
      1,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      5,
      1,
      7,
      0,
      NULL,
      1,
      2,
      0.516274,
      2.960954,
      0.637213,
      NULL,
      1.846075,
      NULL,
      3.144462,
      5,
      4.143356,
      7,
      7.732945,
      2.768660,
      5.997697,
      NULL,
      NULL,
      0.089098,
      4.310892,
      3,
      1,
      1,
      4.099439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.135446,
      1.027250,
      2,
      NULL,
      0.083240,
      NULL,
      0.212454,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      1,
      0.494616,
      1.754931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0.788868,
      NULL,
      NULL,
      NULL,
      0.790323,
      0,
      1.671959,
      4.837032,
      2,
      2,
      0.206089,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.982203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825124,
      NULL,
      0,
      0,
      3.713085,
      1.786073,
      NULL,
      0,
      1.879861,
      3.722988,
      0,
      NULL,
      0,
      NULL,
      1,
      0.501856,
      0,
      0.920475,
      1.197882,
      1.702092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '22401',
      '',
      '',
      1,
      '',
      '',
      '',
      0.990079,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


