set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422857';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '310',
      '40',
      8,
      14,
      NULL,
      NULL,
      1,
      0,
      3,
      '243040',
      NULL,
      ' 4-27-1975',
      30,
      28,
      1,
      NULL,
      NULL,
      3.179362,
      0.645537,
      1.785503,
      0.828836,
      0,
      1,
      0.494222,
      0.334980,
      0.278066,
      NULL,
      0,
      1.508797,
      NULL,
      0.300934,
      1.452377,
      5.808295,
      0,
      1,
      0.390953,
      5.662018,
      1.152211,
      4,
      0,
      2.931527,
      1,
      3.357251,
      0.449398,
      NULL,
      NULL,
      0.685463,
      NULL,
      NULL,
      3.380091,
      1.718871,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675853,
      NULL,
      3.202313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.510108,
      1.815848,
      0,
      NULL,
      1.833518,
      0.227467,
      0.539781,
      1,
      1,
      1.640522,
      NULL,
      1,
      0,
      1,
      1,
      0.406920,
      1.242811,
      NULL,
      0,
      1,
      1.387986,
      0,
      NULL,
      1,
      1.226985,
      1.942319,
      0.848679,
      NULL,
      4,
      0.463837,
      1.410603,
      0.970752,
      0.056737,
      1.661958,
      NULL,
      7,
      5,
      6.356122,
      NULL,
      5,
      3.959487,
      2,
      7.410553,
      1,
      0.542777,
      0,
      2.733647,
      1,
      0.057429,
      NULL,
      1.303858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.599044,
      0,
      1,
      0.676427,
      0,
      0,
      1.596799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.954523,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      4,
      0,
      2,
      1.706871,
      NULL,
      NULL,
      NULL,
      0,
      3.338885,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.406395,
      NULL,
      3,
      2.618679,
      2.104535,
      NULL,
      2,
      0,
      1.177456,
      0,
      0,
      1.514124,
      1,
      1.859150,
      1,
      0,
      0.266850,
      1,
      0.953483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '43102',
      '',
      NULL,
      1.508942,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      NULL,
      4.711854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


