set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422857';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      '40034240',
      4,
      NULL,
      '3231401',
      93,
      3,
      0,
      0,
      '211330',
      0.610157,
      ' 3-18-1978',
      45.821511,
      22.703010,
      NULL,
      NULL,
      0,
      2.187866,
      1.153731,
      0,
      1,
      1,
      1,
      2.462640,
      0.821557,
      1,
      0,
      1.563159,
      0.979009,
      0,
      0.467485,
      NULL,
      1.851973,
      0.354044,
      NULL,
      1.030034,
      1.060148,
      0,
      1,
      1,
      0.560142,
      0.430589,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.752433,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.650974,
      NULL,
      0.791527,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.485755,
      0,
      0,
      0,
      0.387105,
      NULL,
      1.081722,
      NULL,
      2.324968,
      NULL,
      0.720539,
      1.982944,
      2.537400,
      1.669350,
      1,
      0,
      0.550246,
      0,
      NULL,
      1.996766,
      NULL,
      3.997429,
      0.784764,
      2,
      NULL,
      2.109301,
      0,
      6,
      NULL,
      0,
      NULL,
      1,
      0,
      5.740090,
      0,
      NULL,
      NULL,
      3,
      4,
      5,
      6,
      7.729833,
      NULL,
      5,
      NULL,
      0,
      NULL,
      2,
      0.629532,
      1,
      8,
      0.107877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501157,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.090398,
      NULL,
      6,
      1.603228,
      0.909223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      3,
      1.451622,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      3,
      2.708109,
      2,
      5,
      5.048323,
      0,
      1.221626,
      1,
      3,
      0.375824,
      1,
      0,
      0.407478,
      1.041561,
      NULL,
      0.565403,
      2.401513,
      3,
      1,
      0.712791,
      1,
      NULL,
      0.392454,
      1,
      1,
      1,
      1.434437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.383388,
      '12414',
      '',
      '',
      1.010605,
      '',
      NULL,
      '',
      0.612146,
      '',
      NULL,
      '',
      1.825447,
      NULL,
      1.492115,
      2.229115,
      3.907104,
      4.138926,
      0,
      NULL,
      NULL);
commit;
end;
/


