set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422857';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1443',
      '22420042',
      21.276251,
      NULL,
      '3112430',
      227,
      6,
      1,
      2,
      NULL,
      3,
      ' 9- 6-1989',
      63.100540,
      NULL,
      0,
      NULL,
      0,
      0.871038,
      1,
      1.908819,
      0.554714,
      0,
      0,
      2,
      0.951744,
      0,
      0,
      NULL,
      0,
      0,
      1.520159,
      NULL,
      0,
      0.776997,
      0,
      1.196000,
      0,
      NULL,
      1,
      1,
      3.049576,
      1,
      NULL,
      1.322102,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.445382,
      0,
      0.495882,
      1.870076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897076,
      0.340691,
      1.098027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533260,
      NULL,
      1.041377,
      0,
      1.482595,
      5,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      4,
      0.039963,
      NULL,
      0,
      1,
      0,
      NULL,
      1.770798,
      1.907634,
      0.250275,
      0,
      NULL,
      1.283592,
      0.201318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.110590,
      1,
      1,
      NULL,
      5,
      2.357079,
      NULL,
      NULL,
      2,
      8.547596,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.289044,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.228908,
      1.058751,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2.781057,
      1,
      2,
      1,
      0,
      5,
      4,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.469056,
      NULL,
      1.370330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620645,
      1.216389,
      3,
      1.222595,
      0.881074,
      0.924998,
      NULL,
      1.042138,
      NULL,
      NULL,
      0.355937,
      1.931784,
      1,
      0.568376,
      1.733061,
      1.357603,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.056815,
      '34114',
      '',
      '',
      0,
      '',
      '',
      '',
      1.895477,
      '',
      '',
      '',
      NULL,
      3.561691,
      1.938539,
      1.605421,
      1.180865,
      NULL,
      0.586635,
      1,
      NULL);
commit;
end;
/


