set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9875403';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '143',
      '21241304',
      68.938002,
      58,
      '4433333',
      11.733320,
      0,
      NULL,
      1,
      '332414',
      0,
      ' 8- 7-1990',
      5.424997,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.679316,
      0.666737,
      1.736459,
      0,
      0.074496,
      0,
      0.345028,
      0.529319,
      0,
      1,
      1,
      6,
      0.141740,
      1.724484,
      NULL,
      0.553517,
      0.322846,
      1.395605,
      NULL,
      NULL,
      9,
      1,
      0,
      3,
      1.683891,
      NULL,
      NULL,
      NULL,
      0.519822,
      NULL,
      NULL,
      0,
      1,
      1,
      1.951336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584705,
      1.216871,
      0.175679,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151291,
      NULL,
      6.171277,
      4.306925,
      1.796384,
      0,
      NULL,
      NULL,
      1,
      NULL,
      7,
      1.686190,
      1,
      0.892826,
      1.753234,
      NULL,
      NULL,
      0,
      NULL,
      0.292437,
      0,
      1,
      NULL,
      5,
      1,
      1.380534,
      NULL,
      NULL,
      2,
      1.272316,
      NULL,
      1.904547,
      8.058105,
      5,
      6,
      3,
      NULL,
      8,
      6,
      1.367920,
      NULL,
      NULL,
      5,
      NULL,
      5.564293,
      3,
      0.184838,
      0.876583,
      0.046022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330558,
      1,
      2,
      2,
      1,
      NULL,
      4.786749,
      0.304261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201341,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.264755,
      1.966403,
      NULL,
      0,
      2.446488,
      0.452912,
      0.471128,
      4,
      0.071907,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.897952,
      0,
      3.026183,
      0,
      1.741429,
      1,
      1,
      1,
      3,
      2.493370,
      0.609460,
      NULL,
      1.136510,
      1.190505,
      0,
      0.246380,
      1.038297,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.840643,
      2.385100,
      1,
      6.870119,
      NULL,
      0,
      0.339040,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458232,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.232202,
      2,
      3.899378,
      1.931522,
      NULL,
      0,
      1,
      4.652293,
      '21023',
      NULL,
      '11344',
      1.922389,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      NULL,
      1,
      5,
      1,
      3,
      2,
      4,
      1);
commit;
end;
/


