set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9875403';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '301',
      NULL,
      NULL,
      43,
      '2031022',
      12,
      NULL,
      NULL,
      2,
      '331242',
      NULL,
      NULL,
      NULL,
      33,
      1,
      NULL,
      0.332630,
      1,
      0.921716,
      NULL,
      1,
      1,
      0.060872,
      2,
      NULL,
      0.010159,
      5.711829,
      0,
      1,
      4,
      0.487176,
      NULL,
      2,
      1.779827,
      0,
      NULL,
      1,
      0,
      4,
      NULL,
      0,
      3,
      2.545980,
      1,
      NULL,
      NULL,
      0.203769,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.742872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295717,
      NULL,
      4,
      0,
      4,
      1.730246,
      3.806877,
      0.549795,
      1.248774,
      0,
      1,
      0,
      1,
      2,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      5.842316,
      NULL,
      0.134628,
      1.673445,
      4,
      5.005510,
      3.474030,
      NULL,
      NULL,
      NULL,
      NULL,
      2.345685,
      5,
      1.369102,
      NULL,
      0.015811,
      1.574216,
      6,
      NULL,
      3,
      0,
      7,
      6.509986,
      8.526292,
      NULL,
      1.546645,
      1.528348,
      NULL,
      0,
      0.458776,
      7.528249,
      1.068251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155352,
      NULL,
      0,
      0,
      1.678452,
      0,
      NULL,
      0.631306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.535771,
      0.598370,
      3.034464,
      3.233815,
      NULL,
      2,
      0.758194,
      1,
      1.959230,
      0.118274,
      1.708344,
      NULL,
      0.531770,
      NULL,
      NULL,
      NULL,
      0.336684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284134,
      2,
      3,
      0.867935,
      1.063875,
      2,
      1,
      3.358034,
      1.045709,
      0,
      0,
      1.376150,
      1.650047,
      1,
      1,
      1,
      1.931092,
      1.914331,
      0.786460,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.578041,
      '42023',
      '32033',
      NULL,
      1.589088,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3.081775,
      1,
      2.546455,
      3,
      0,
      NULL,
      1,
      2.865922,
      NULL);
commit;
end;
/


