set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '3300022',
      34,
      3,
      0,
      2,
      '211400',
      1,
      ' 9-17-1990',
      40.392750,
      NULL,
      1.419995,
      NULL,
      NULL,
      2,
      1.857263,
      0.385330,
      NULL,
      0,
      NULL,
      1.759750,
      3.647487,
      0,
      0,
      0.236978,
      0,
      1,
      NULL,
      1.669888,
      0,
      0.856565,
      0,
      1,
      0,
      NULL,
      3.146681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272272,
      2,
      1,
      1.266904,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.122841,
      1.219991,
      0,
      3,
      1,
      0.846228,
      0.054370,
      1,
      1.351440,
      0,
      0,
      0.711983,
      1.414148,
      0,
      1.694344,
      NULL,
      1.429967,
      0.814892,
      NULL,
      1,
      5,
      NULL,
      0.749908,
      1.757701,
      0.859361,
      5.063730,
      1.722812,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.892883,
      1.980083,
      0,
      NULL,
      7.084387,
      NULL,
      0,
      2.188468,
      0.842281,
      2,
      0,
      2.492091,
      NULL,
      NULL,
      1.435209,
      NULL,
      NULL,
      4.869691,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143841,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.292322,
      1.082171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892957,
      NULL,
      NULL,
      3,
      NULL,
      0.586830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.434781,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303905,
      0.047607,
      5,
      0.726728,
      1,
      3.653741,
      0,
      NULL,
      NULL,
      0,
      1,
      0.734828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.561613,
      NULL,
      0,
      NULL,
      1.696226,
      1.679995,
      NULL,
      1,
      0.671069,
      0,
      0,
      0,
      NULL,
      0,
      0.489529,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.942228,
      '33141',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


