set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '4430311',
      1.491032,
      5,
      1,
      NULL,
      '211032',
      3,
      ' 0-22-1997',
      23,
      NULL,
      0,
      NULL,
      0.988964,
      NULL,
      1,
      0.989062,
      0.575717,
      0,
      2.583203,
      0.952180,
      1.604772,
      0.732312,
      0.102343,
      NULL,
      1.850639,
      NULL,
      1.446484,
      0,
      1,
      1,
      NULL,
      1.504920,
      1.176501,
      0.880149,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204058,
      0.939567,
      NULL,
      1.184856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676275,
      0,
      1.032739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.978170,
      0,
      NULL,
      4.564145,
      0,
      0.012234,
      NULL,
      4.265874,
      NULL,
      1,
      3,
      1,
      0,
      1.727663,
      1.838144,
      0.520664,
      NULL,
      NULL,
      1.229112,
      0,
      0,
      0,
      1,
      0,
      0.684673,
      0,
      1.822197,
      1.052494,
      0.014178,
      0.738447,
      0.600073,
      NULL,
      1.765000,
      1.227696,
      5,
      1.946281,
      5,
      3.982954,
      2.696046,
      0,
      2,
      4,
      4.407957,
      0,
      4,
      0.709192,
      NULL,
      NULL,
      6.815901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022388,
      4,
      1,
      1,
      0,
      2.995407,
      1.786117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.689981,
      NULL,
      3,
      3.532124,
      1,
      3.360477,
      3,
      NULL,
      0,
      NULL,
      2,
      5.368151,
      2.848701,
      1.847022,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      5,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.974860,
      1,
      0.843819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751555,
      1.649893,
      0,
      0,
      0.055198,
      1.963073,
      0,
      1.501418,
      1,
      0,
      NULL,
      1,
      1.666280,
      NULL,
      NULL,
      1.149357,
      NULL,
      1.295063,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.830096,
      '00132',
      NULL,
      '',
      0.294900,
      '',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


