set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '1212412',
      53.871112,
      0,
      3.697538,
      3,
      '241230',
      3.022277,
      ' 9- 6-2000',
      38.460121,
      NULL,
      NULL,
      NULL,
      9.495778,
      0.086110,
      NULL,
      1.305399,
      1.606910,
      0,
      2.438439,
      NULL,
      0,
      1,
      NULL,
      1.666566,
      0.916117,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.014068,
      NULL,
      NULL,
      0,
      1.266256,
      1,
      1.782998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.269996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.816229,
      NULL,
      0.336820,
      1.879085,
      0.028997,
      1,
      1,
      1,
      1.191721,
      1.010936,
      0.666939,
      0,
      NULL,
      0,
      1,
      0.534247,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1.151236,
      1,
      1,
      1,
      1,
      1.776087,
      1.554147,
      0,
      0,
      1,
      1.142486,
      NULL,
      5.091250,
      3.528364,
      NULL,
      4,
      1.872709,
      0.759915,
      1,
      3.258645,
      NULL,
      1.688619,
      1,
      1.079037,
      NULL,
      NULL,
      5.468987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830815,
      0.709742,
      1,
      0,
      0.594995,
      0,
      0,
      0.510368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.337656,
      2.881109,
      NULL,
      7.690259,
      2,
      1.851009,
      0.103029,
      0.849796,
      4.336854,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0.199000,
      0.045609,
      6,
      7,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.573510,
      6,
      3.324277,
      2,
      3,
      3,
      7,
      1.930729,
      1.419079,
      1.380877,
      1,
      1.000595,
      1.158017,
      2.128894,
      1.531240,
      0,
      NULL,
      NULL,
      NULL,
      1.568391,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0.735402,
      0.617026,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '43244',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


